/*
 * Decompiled with CFR 0.152.
 */
package sufftracker;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import sufftracker.BeamerView;
import sufftracker.ContentFrame;
import sufftracker.Contestant;
import sufftracker.ContestantPanel;
import sufftracker.DataHolder;
import sufftracker.SettingsHolder;

public class Window
extends ContentFrame {
    private DataHolder data = new DataHolder();
    private HashMap<String, ContestantPanel> contestantPanels = new HashMap();
    int widthOfContestant;
    int heightOfContestant;
    private BeamerView beamer;
    private JButton AddContestantButton;
    private JPanel ContestantPanelContainer;
    private JScrollPane ContestantsArea;
    private JLabel NumConsumedLabel;
    private JLabel NumContestantLabel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JButton linkLabel;
    private JPanel testPanel;

    public Window() {
        this.data.addObserver(this);
        this.initComponents();
        SettingsHolder s = SettingsHolder.instance();
        while (s.getString("session") == null) {
            String def = "Session";
            String session = JOptionPane.showInputDialog(null, "Bitte gebe einen Namen der Session ein", def);
            if (session == null) {
                System.exit(0);
            }
            if ((session = session.trim()).isEmpty() || session.equals(def)) {
                JOptionPane.showMessageDialog(null, "Bitte gebe einen Namen ein.", "Leer", 0);
                continue;
            }
            s.put("session", session);
        }
        this.setBounds(s.getInt("mainX", 0), s.getInt("mainY", 0), s.getInt("mainW", 1024), s.getInt("mainH", 800));
        this.data.loadData();
        ArrayList<Contestant> c = this.data.getAllContestants();
        int m = this.data.getMax();
        for (Contestant so : c) {
            ContestantPanel p = new ContestantPanel(so, this);
            p.setCurrentMax(m);
            this.contestantPanels.put(so.latest.person, p);
            this.testPanel.add(p);
            if (this.widthOfContestant != 0) continue;
            this.widthOfContestant = p.getSize().width;
            this.heightOfContestant = p.getSize().height;
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Window.this.contentChanged();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Window.this.beamer.close();
            }
        });
        this.contentChanged();
        this.setTitle("SuffTracker - Main - " + s.getString("session"));
        this.linkLabel.setText("www.sufftracker.lrinke.de/session/" + s.getString("session"));
        this.setVisible(true);
        this.beamer = new BeamerView(this, this.data);
    }

    public void close() {
        SettingsHolder s = SettingsHolder.instance();
        Rectangle r = this.getBounds();
        s.put("mainX", r.x);
        s.put("mainY", r.y);
        s.put("mainW", r.width);
        s.put("mainH", r.height);
        s.save();
        System.exit(0);
    }

    @Override
    public void contentChanged() {
        int m = this.data.getMax();
        this.NumConsumedLabel.setText(String.valueOf(this.data.getNumConsumed()));
        this.NumContestantLabel.setText(String.valueOf(this.data.getNumPlayers()));
        this.ContestantsArea.repaint();
        int counter = 0;
        int spacing = 20;
        int spaceX = this.ContestantsArea.getSize().width + spacing;
        int numPerLine = spaceX / (this.widthOfContestant + spacing);
        for (Contestant c : this.data.getAllContestants()) {
            ContestantPanel p = this.contestantPanels.get(c.latest.person);
            p.setCurrentMax(m);
            int l = (this.widthOfContestant + spacing) * (counter % numPerLine);
            int t = (this.heightOfContestant + spacing) * (counter / numPerLine);
            p.moveTo(l, t);
            ++counter;
        }
        int numLines = (int)Math.ceil((double)counter / (double)numPerLine);
        this.testPanel.setPreferredSize(new Dimension(numPerLine * this.widthOfContestant + (numPerLine - 1) * spacing, numLines * this.heightOfContestant + (numLines - 1) * spacing));
    }

    private void initComponents() {
        this.AddContestantButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.ContestantsArea = new JScrollPane();
        this.ContestantPanelContainer = new JPanel();
        this.testPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.NumContestantLabel = new JLabel();
        this.NumConsumedLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.linkLabel = new JButton();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(0);
        this.AddContestantButton.setFont(new Font("Cambria", 0, 14));
        this.AddContestantButton.setText("Neuer Spieler");
        this.AddContestantButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.AddContestantButtonActionPerformed(evt);
            }
        });
        this.ContestantPanelContainer.setBackground(new Color(204, 204, 204));
        GroupLayout testPanelLayout = new GroupLayout(this.testPanel);
        this.testPanel.setLayout(testPanelLayout);
        testPanelLayout.setHorizontalGroup(testPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1045, Short.MAX_VALUE));
        testPanelLayout.setVerticalGroup(testPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 621, Short.MAX_VALUE));
        GroupLayout ContestantPanelContainerLayout = new GroupLayout(this.ContestantPanelContainer);
        this.ContestantPanelContainer.setLayout(ContestantPanelContainerLayout);
        ContestantPanelContainerLayout.setHorizontalGroup(ContestantPanelContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ContestantPanelContainerLayout.createSequentialGroup().addContainerGap().addComponent(this.testPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        ContestantPanelContainerLayout.setVerticalGroup(ContestantPanelContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ContestantPanelContainerLayout.createSequentialGroup().addContainerGap().addComponent(this.testPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.ContestantsArea.setViewportView(this.ContestantPanelContainer);
        this.jLabel1.setFont(new Font("Cambria", 0, 14));
        this.jLabel1.setText("S\u00e4ufer haben bisher");
        this.NumContestantLabel.setFont(new Font("Cambria", 1, 14));
        this.NumContestantLabel.setForeground(new Color(102, 102, 102));
        this.NumContestantLabel.setText("99");
        this.NumConsumedLabel.setFont(new Font("Cambria", 1, 14));
        this.NumConsumedLabel.setForeground(new Color(102, 102, 102));
        this.NumConsumedLabel.setText("999");
        this.jLabel4.setFont(new Font("Cambria", 0, 14));
        this.jLabel4.setText("Bier getrunken");
        this.linkLabel.setFont(new Font("Cambria", 0, 14));
        this.linkLabel.setText("jButton1");
        this.linkLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.linkLabelActionPerformed(evt);
            }
        });
        this.jButton1.setFont(new Font("Cambria", 0, 14));
        this.jButton1.setText("Neue Session");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ContestantsArea).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.AddContestantButton).addGap(18, 18, 18).addComponent(this.jButton1).addGap(18, 18, 18).addComponent(this.linkLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.NumContestantLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.NumConsumedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.AddContestantButton).addComponent(this.jLabel1).addComponent(this.NumContestantLabel).addComponent(this.NumConsumedLabel).addComponent(this.jLabel4).addComponent(this.linkLabel).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ContestantsArea).addContainerGap()));
        this.pack();
    }

    @Override
    public void contentAdded(String name) {
        ContestantPanel p = new ContestantPanel(this.data.contestant(name), this);
        p.setSize(p.getPreferredSize());
        if (this.widthOfContestant == 0) {
            this.widthOfContestant = p.getSize().width;
            this.heightOfContestant = p.getSize().height;
        }
        this.contestantPanels.put(name, p);
        this.testPanel.add(p);
    }

    private void AddContestantButtonActionPerformed(ActionEvent evt) {
        this.data.addContestant(this);
    }

    private void linkLabelActionPerformed(ActionEvent evt) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(this.linkLabel.getText()));
            }
            catch (IOException | URISyntaxException ex) {
                Logger.getLogger(Window.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            this.data.ereaseSession();
            Thread.sleep(200L);
            Runtime runtime = Runtime.getRuntime();
            String s = Window.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            s = s.substring(s.lastIndexOf("/") + 1);
            s = URLDecoder.decode(s, "UTF-8");
            JOptionPane.showMessageDialog(this, s);
            runtime.exec("java -jar \"" + s + "\"");
        }
        catch (IOException | InterruptedException ex) {
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage());
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            // empty catch block
        }
        Window window = new Window();
    }
}

